#if (renderTrees = 0 & renderAll = 0)
	#declare treeTexture = texture {
		pigment {
			bozo
			color_map {
				[ 0.0 color Orange ]
				[ 0.3 color Orange ]
				[0.8 color Blue]
				[ 1.0 color Blue ]
			}
			scale .5
		}
		finish {
			ambient .45
		}
	}

	#declare treeShape = union {
		cylinder {
			<0, 0, 0>,	<0, 2, 0>, .5
		}
		sphere {
			<0, 3, 0>, 1.5
		}
		scale .75
		texture { treeTexture }
	}
	
#else
	#include "palm.mesh"
	#declare treeShape = object { TREE
		scale 6
	}
#end

//copse 1
#declare copse1loc = <4*hex_diag, 0, 2*hex_diag> + <0, sun_height, 0>;
#declare c1tree1 = trace(land, copse1loc, <0, -1, 0>, nvector);
#declare c1tree2 = trace(land, copse1loc+<5, 0, 2>, <0, -1, 0>, nvector);
#declare c1tree3 = trace(land, copse1loc+<5, 0, -4>, <0, -1, 0>, nvector);
#declare c1tree4 = trace(land, copse1loc+<7, 0, -15>, <0, -1, 0>, nvector);
#declare c1tree5 = trace(land, copse1loc+<12, 0, 10>, <0, -1, 0>, nvector);
#declare c1tree6 = trace(land, copse1loc+<9, 0, 2>, <0, -1, 0>, nvector);
#declare c1tree7 = trace(land, copse1loc+<16, 0, 3>, <0, -1, 0>, nvector);
#declare c1tree8 = trace(land, copse1loc+<20, 0, 5>, <0, -1, 0>, nvector);
#declare c1tree9 = trace(land, copse1loc+<21, 0, -12>, <0, -1, 0>, nvector);
union {
	object { treeShape
		translate c1tree1
	}
	
	object { treeShape
		scale 1.5
		translate c1tree2
	}
	
	object { treeShape
		scale 2
		translate c1tree3
	}
	
	object { treeShape
		scale 2
		translate c1tree4
	}
	
	object { treeShape
		scale 1.25
		translate c1tree5
	}
	
	object { treeShape
		scale 1.1
		translate c1tree6
	}

	object { treeShape
		scale 2.5
		translate c1tree7
	}

	object { treeShape
		scale 1.75
		translate c1tree8
	}

	object { treeShape
		scale 1.75
		translate c1tree9
	}

}

//copse 2
#declare copse2loc = <-7*hex_diag, 0, 5*hex_diag> + <0, sun_height, 0>;
#declare c2tree1 = trace(land, copse2loc, <0, -1, 0>, nvector);
#declare c2tree2 = trace(land, copse2loc+<0, 0, -2>, <0, -1, 0>, nvector);
#declare c2tree3 = trace(land, copse2loc+<9, 0, -7.5>, <0, -1, 0>, nvector);
#declare c2tree4 = trace(land, copse2loc+<7, 0, -15>, <0, -1, 0>, nvector);
#declare c2tree5 = trace(land, copse2loc+<12, 0, 10>, <0, -1, 0>, nvector);
#declare c2tree6 = trace(land, copse2loc+<9, 0, 2>, <0, -1, 0>, nvector);
#declare c2tree7 = trace(land, copse2loc+<16, 0, -3>, <0, -1, 0>, nvector);
#declare c2tree8 = trace(land, copse2loc+<20, 0, 5>, <0, -1, 0>, nvector);
#declare c2tree9 = trace(land, copse2loc+<21, 0, -12>, <0, -1, 0>, nvector);
#declare c2tree10 = trace(land, copse2loc+<25, 0, -2>, <0, -1, 0>, nvector);
#declare c2tree11 = trace(land, copse2loc+<27, 0, 4>, <0, -1, 0>, nvector);
#declare c2tree12 = trace(land, copse2loc+<32, 0, -19>, <0, -1, 0>, nvector);
#declare c2tree13 = trace(land, copse2loc+<28, 0, -25>, <0, -1, 0>, nvector);
#declare c2tree14 = trace(land, copse2loc+<18, 0, -17.5>, <0, -1, 0>, nvector);
union {
	object { treeShape
		translate c2tree1
	}
	
	object { treeShape
		scale 1.75
		translate c2tree2
	}
	
	object { treeShape
		scale 2.25
		translate c2tree3
	}
	
	object { treeShape
		scale 1.9
		translate c2tree4
	}
	
	object { treeShape
		scale 1.5
		translate c2tree5
	}
	
	object { treeShape
		scale 1.8
		translate c2tree6
	}

	object { treeShape
		scale 2.25
		translate c2tree7
	}

	object { treeShape
		scale 1.65
		translate c2tree8
	}

	object { treeShape
		scale 1.5
		translate c2tree9
	}
	
	object { treeShape
		scale 1.7
		translate c2tree10
	}

	object { treeShape
		scale 1.8
		translate c2tree11
	}

	object { treeShape
		scale 1.8
		translate c2tree12
	}

	object { treeShape
		scale 1.6
		translate c2tree13
	}

	object { treeShape
		scale 1.55
		translate c2tree14
	}
}

//a couple of pigasi
#include "pigasi.inc"
#declare pigasiCount = 14;
#declare pigasiLoc = seed(55938688);
#declare zSize = 35;
#declare zLow = -25+copse2loc.z;
#declare xSize = 32;
#declare xLow = 0+copse2loc.x;
#while (pigasiCount > 0)
	#declare pigasiX = rand(pigasiLoc)*xSize+xLow;
	#declare pigasiZ = rand(pigasiLoc)*zSize+zLow;
	#declare pigasiSize = 1+rand(pigasiLoc)/2;
	#declare pigasiRotate = <rand(pigasiLoc), rand(pigasiLoc), rand(pigasiLoc)>*40-20;
	#declare groundLevel = trace(land, <pigasiX, sun_height, pigasiZ>, <0, -1, 0>, nvector);
	//pigasi fly up to ten yards off the ground
	#declare pigasiY = groundLevel.y + rand(pigasiLoc)*10;
	object { pigasi
		scale pigasiSize
		rotate pigasiRotate
		translate <pigasiX, pigasiY, pigasiZ>
	}
	#declare pigasiCount = pigasiCount-1;
#end

